import os

def process_file(input_file, output_file):
    with open(input_file, 'r', encoding='utf-8') as f:
        lines = f.readlines()

    # 找到 "Frame Number" 行的位置
    start_index = None
    for i, line in enumerate(lines):
        if line.strip().startswith("Frame Number"):
            start_index = i + 1  # 下一行开始处理
            break

    if start_index is None:
        print("not found 'Frame Number'")
        return

    # 输出处理后的内容到文件
    with open(output_file, 'w', encoding='utf-8') as f_out:
        for line in lines[start_index:]:
            line = line.strip()
            if not line:  # 跳过空行
                continue
            parts = line.split('\t')
            if len(parts) < 5:  # 确保至少有时间戳和xyz列
                print("wrong line ", line)
                continue

            timestamp = parts[1]  # 第2列为时间戳
            x, y, z = parts[-3:]  # 最后三列为x, y, z
            quaternion = "0 0 0 1"  # 补齐四元数

            # 写入输出文件，格式为：timestamp x y z qx qy qz qw
            f_out.write("{timestamp} {x} {y} {z} {quaternion}\n".format(
                timestamp=timestamp, x=x, y=y, z=z, quaternion=quaternion))

    print("finish: ", output_file)

# 示例用法
input_file = "no_realtime-40-2500.txt"  # 替换为您的输入文件路径
output_file = "tum_no_realtime-40-2500.txt"  # 输出文件路径
process_file(input_file, output_file)
